#include "CGenericReadWriteDialog.h"

#include <QMessageBox>

#include <QrfeReaderInterface>
#include <tag/QrfeGenericTag>


CGenericReadWriteDialog::CGenericReadWriteDialog(QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);
	setInfoEdit(ui.infoEdit);

	connect(ui.okButton, 			SIGNAL(clicked()), 					this, SLOT(accept()));
	connect(ui.cancelButton, 		SIGNAL(clicked()), 					this, SLOT(reject()));

	connect(ui.readButton, 			SIGNAL(clicked()), 					this, SLOT(read()));
	connect(ui.writeButton, 		SIGNAL(clicked()), 					this, SLOT(write()));

	connect(ui.memBankBox, 			SIGNAL(valueChanged(int)), 			this, SLOT(paramsChanged()));
	connect(ui.wordAddressBox, 		SIGNAL(valueChanged(int)), 			this, SLOT(paramsChanged()));
	connect(ui.wordCountBox, 		SIGNAL(valueChanged(int)), 			this, SLOT(paramsChanged()));

}

CGenericReadWriteDialog::~CGenericReadWriteDialog()
{

}

int CGenericReadWriteDialog::exec ( QrfeReaderInterface* ph, QString tagId, uint /*antennaId*/ )
{
	QrfeTagManipulatorInterface* tagManipulator;
	if((tagManipulator = ph->getTagManipulator()) == 0)
		return 0;

	m_tag = new QrfeGenericTag(tagId, tagManipulator, this);

	clearInfo();

	ui.tagIdEdit->setText(m_tag->tagId());

	ui.memBankBox->setValue(0);
	ui.wordAddressBox->setValue(0);
	ui.wordCountBox->setValue(1);
	ui.accessPasswordEdit->setText("00-00-00-00");
	ui.dataLineEdit->clear();

	int res = QDialog::exec();

	delete m_tag;

	return res;
}


void CGenericReadWriteDialog::read()
{
	clearInfo();

	if(!ui.accessPasswordEdit->hasAcceptableInput())
	{
		QMessageBox::critical(this, "Error", "The password is not valid!");
		return;
	}

	bool ok = false;
	QByteArray passw = QrfeGlobal::stringToBytes(ui.accessPasswordEdit->text(), &ok);
	if(!ok)
	{
		QMessageBox::critical(this, "Error", "The password is not valid!");
		return;
	}

	uchar 	membank = ui.memBankBox->value();
	ushort 	address = ui.wordAddressBox->value();
	uchar 	count   = ui.wordCountBox->value();

	QrfeGlobal::TMIResult res = QrfeGlobal::TMI_ERROR;

	QByteArray data;

	infoSetProcessing("-- Reading --");

	res = m_tag->readFromTag(membank, address, passw, count, data);

	QString inputMask;
	QString text;
	if(res == QrfeGlobal::TMI_OK)
	{
		infoSetOK("-- Read data from tag - OK -- ");
		infoAppend("Read the data: " + QrfeGlobal::bytesToString(data));

		for(int i = 0; i < data.size(); i++)
			inputMask += "HH-";
		inputMask.remove(inputMask.size()-1, 1);

		text = QrfeGlobal::bytesToString(data);

		ui.writeButton->setEnabled(true);
	}
	else
	{
		inputMask = "";
		text = "";
		handleError(res, "Could not read data from the tag");
	}

	ui.dataLineEdit->setInputMask(inputMask);
	ui.dataLineEdit->setText(text);
}

void CGenericReadWriteDialog::write()
{
	bool ok;

	clearInfo();

	if(!ui.accessPasswordEdit->hasAcceptableInput())
	{
		QMessageBox::critical(this, "Error", "The password is not valid!");
		return;
	}

	ok = false;
	QByteArray passw = QrfeGlobal::stringToBytes(ui.accessPasswordEdit->text(), &ok);
	if(!ok)
	{
		QMessageBox::critical(this, "Error", "The password is not valid!");
		return;
	}

	if(!ui.dataLineEdit->hasAcceptableInput())
	{
		QMessageBox::critical(this, "Error", "The data is not valid!");
		return;
	}

	ok = false;
	QByteArray data = QrfeGlobal::stringToBytes(ui.dataLineEdit->text(), &ok);
	if(!ok)
	{
		QMessageBox::critical(this, "Error", "The data is not valid!");
		return;
	}

	uchar 	membank = ui.memBankBox->value();
	ushort 	address = ui.wordAddressBox->value();

	QrfeGlobal::TMIResult res = QrfeGlobal::TMI_ERROR;

	infoSetProcessing("-- Writing --");

	res = m_tag->writeToTag(membank, address, passw, data);

	if(res == QrfeGlobal::TMI_OK)
	{
		infoSetOK("-- Wrote data from tag - OK -- ");
		infoAppend("Wrote the data: " + QrfeGlobal::bytesToString(data));
	}
	else
	{
		handleError(res, "Could not write data from the tag");
	}
}

void CGenericReadWriteDialog::paramsChanged()
{
	ui.writeButton->setEnabled(false);
}

